<# :
@echo off
REM ----------------------------------------------------------------------------
REM METALZINHO.COM 
REM HYBRID SCRIPT: This section runs in Batch to launch PowerShell safely.
REM We use this method to bypass the character encoding issues (Â, Ã, etc.)
REM that cause standard .bat files to fail in folders like "LÂMINA".
REM ----------------------------------------------------------------------------
setlocal
cd /d "%~dp0"
powershell -NoLogo -NoProfile -ExecutionPolicy Bypass -Command "Invoke-Command -ScriptBlock ([ScriptBlock]::Create((Get-Content -Raw '%~f0')))"
pause
exit /b
#>

# ==============================================================================
# POWERSHELL LOGIC STARTS HERE (This handles the heavy lifting)
# ==============================================================================

$scriptPath = Get-Location
Write-Host "==============================================================" -ForegroundColor Cyan
Write-Host " INICIANDO PROCESSAMENTO AUTOMATICO DE DADOS" -ForegroundColor Cyan
Write-Host " Raiz: $scriptPath" -ForegroundColor Gray
Write-Host "=============================================================="

# 1. Find all 'Results.csv' files recursively (Handles 'LÂMINA' correctly)
# ------------------------------------------------------------------------------
$foundFiles = Get-ChildItem -Path $scriptPath -Filter "Results.csv" -Recurse -ErrorAction SilentlyContinue

if ($foundFiles.Count -eq 0) {
    Write-Host " [ERRO] Nenhum arquivo 'Results.csv' encontrado nesta pasta ou subpastas." -ForegroundColor Red
    exit
}

Write-Host " -> Encontrados $($foundFiles.Count) arquivos para processar." -ForegroundColor White

foreach ($file in $foundFiles) {
    $dir = $file.DirectoryName
    $outputFile = Join-Path -Path $dir -ChildPath "medidas parede.csv"
    
    # Visual spacer for log readability
    Write-Host ""

    # Show relative path for clarity (e.g., "\GRUPO A\LÂMINA 1")
    $relativePath = $dir.Substring($scriptPath.Path.Length)
    Write-Host " Pasta: ..$relativePath" -ForegroundColor Yellow

    # FAILSAFE: Don't overwrite existing files
    if (Test-Path $outputFile) {
        Write-Host "    [PULADO] 'medidas parede.csv' ja existe." -ForegroundColor DarkGray
        continue
    }

    try {
        # 2. Read and Validate CSV
        # --------------------------------------------------------------------------
        $csv = Import-Csv $file.FullName
        
        if ($csv.Count -eq 0) {
            Write-Host "    [FALHA] O arquivo Results.csv esta vazio." -ForegroundColor Red
            continue
        }

        # 3. Detect the correct data column dynamically
        # --------------------------------------------------------------------------
        $cols = $csv[0].PSObject.Properties.Name
        $idx = $cols[0] # First column is assumed to be Index/Label
        
        # Look for first column that is NOT index and IS a number
        $measure = $cols | Where-Object {$_ -ne $idx} | Where-Object { ($csv[0].$_ -as [double]) -ne $null } | Select-Object -First 1

        if (-not $measure) {
            Write-Host "    [FALHA] Nao foi possivel identificar a coluna de medidas." -ForegroundColor Red
            continue
        }

        # 4. Transform Data (The Pairing Logic)
        # --------------------------------------------------------------------------
        $out = @()
        for ($i = 0; $i -lt $csv.Count; $i += 2) {
            if ($i + 1 -lt $csv.Count) {
                # Get value from Row i (Parede) and Row i+1 (Dentro)
                $p = $csv[$i].$measure
                $d = $csv[$i+1].$measure
                
                # Create the new row
                $obj = [PSCustomObject]@{
                    parede = $p
                    dentro = $d
                }
                $out += $obj
            }
        }

        # 5. Export (Replace dots with commas)
        # --------------------------------------------------------------------------
        $out | ForEach-Object {
            $_.parede = $_.parede -replace '\.', ','
            $_.dentro = $_.dentro -replace '\.', ','
            $_
        } | Export-Csv -Path $outputFile -NoTypeInformation -Delimiter ";" -Encoding UTF8

        Write-Host "    [SUCESSO] Arquivo gerado com $( $out.Count ) pares." -ForegroundColor Green

    } catch {
        Write-Host "    [ERRO CRITICO] $($_.Exception.Message)" -ForegroundColor Red
    }
}

Write-Host "`n==============================================================" -ForegroundColor Cyan
Write-Host " CONCLUIDO." -ForegroundColor Cyan